unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, ImgList, Buscador, Buttons;

type
  TMainForm = class(TForm)
    ListView1: TListView;
    Label1z: TLabel;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    Bevel1: TBevel;
    b_buscar: TButton;
    Label1: TLabel;
    TreeView1: TTreeView;
    ImageList1: TImageList;
    cbx_pausa: TCheckBox;
    cbx_NoRedraw: TCheckBox;
    procedure b_buscarClick(Sender: TObject);
    procedure cbx_pausaClick(Sender: TObject);
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
  private
    buscador: TBuscador;

    procedure OnEnd(Sender: TObject);
  end;


var
  MainForm: TMainForm;

implementation

{$R *.DFM}


//~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
procedure TMainForm.b_buscarClick(Sender: TObject);
begin
  b_buscar.enabled := false;
  cbx_pausa.enabled  := true;
  cbx_NoRedraw.enabled := false;

  TreeView1.Items.Clear;
  ListView1.Items.Clear;

  if cbx_NoRedraw.checked then
  begin
    Treeview1.Items.BeginUpdate;
    ListView1.Items.BeginUpdate;
  end;

  buscador             := TBuscador.Create;
  buscador.Lista       := ListView1;
  buscador.Arbol       := Treeview1;
  buscador.Carpeta     := Edit1.text;
  buscador.Subcarpetas := CheckBox1.Checked;
  buscador.OnEnd       := Self.OnEnd;

  buscador.Execute;
end;

//~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
procedure TMainForm.OnEnd(Sender: TObject);
begin
  MessageBox(GetActiveWindow, PChar(FormatFloat('#,0', ListView1.Items.Count) + ' coincidencias en un total de '+
                                    FormatFloat('#,0', TreeView1.Items.Count) + ' carpetas.' + #13 + 'Tiempo empleado: ' +
                                    FormatFloat('#,0', buscador.MSecs) + ' milisegundos.'),
            'Atencin', MB_ICONINFORMATION);

  b_buscar.enabled  := true;
  cbx_pausa.enabled := false;
  cbx_NoRedraw.enabled := true;

  if cbx_NoRedraw.checked then
  begin
    Treeview1.Items.EndUpdate;
    ListView1.Items.EndUpdate;
  end;

  FreeAndNil(buscador);
end;

//~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
procedure TMainForm.cbx_pausaClick(Sender: TObject);
begin
  buscador.Pause(cbx_pausa.checked);
end;

//~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~
procedure TMainForm.TreeView1Change(Sender: TObject; Node: TTreeNode);
begin
  Node.SelectedIndex := Node.ImageIndex;
end;

end.
